@extends('admin.layout.page-app')
@section('page_title', __('label.video_leaderboard'))
@section('tab_title', __('label.video_leaderboard'))

@section('content')
    @include('admin.layout.sidebar')

    <!-- Select2 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" />

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.video_leaderboard')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.video_leaderboard')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Search & Table -->
            <div class="card custom-border-card">
                <div class="page-search">
                    <div class="sorting mr-2 w-25">
                        <label>{{__('label.sort_by')}}</label>
                        <select class="form-control" name="input_category" id="input_category">
                            <option value="0" selected>{{__('label.all_category')}}</option>
                            @for ($i = 0; $i < count($category); $i++)
                                <option value="{{ $category[$i]['id'] }}">
                                    {{ $category[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_skill" id="input_skill">
                            <option value="0" selected>{{__('label.all_skill')}}</option>
                            @for ($i = 0; $i < count($skill); $i++)
                                <option value="{{ $skill[$i]['id'] }}">
                                    {{ $skill[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_classification" id="input_classification">
                            <option value="0" selected>{{__('label.all_classification')}}</option>
                            @for ($i = 0; $i < count($classification); $i++)
                                <option value="{{ $classification[$i]['id'] }}">
                                    {{ $classification[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <select class="form-control" name="input_level" id="input_level">
                            <option value="0" selected>{{__('label.all_level')}}</option>
                            @for ($i = 0; $i < count($level); $i++)
                                <option value="{{ $level[$i]['id'] }}">
                                    {{ $level[$i]['name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                </div>
                <div class="page-search mb-3">
                    <div class="sorting mr-3 w-50">
                        <label>{{__('label.sort_by')}}</label>
                        <select class="form-control" name="input_user" id="input_user">
                            <option value="0" selected>{{__('label.all_users')}}</option>
                            @for ($i = 0; $i < count($user); $i++)
                                <option value="{{ $user[$i]['id'] }}">
                                    {{ $user[$i]['user_name'] }} | {{ $user[$i]['full_name'] }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    <div class="sorting mr-2 w-25">
                        <label>{{__('label.start')}} : </label>
                        <input type="date" name="input_start_date" id="input_start_date" value="{{ date('Y-m-d') }}" class="form-control" max="{{ date('Y-m-d') }}">
                    </div>
                    <div class="sorting mr-2 w-25">
                        <label>{{__('label.end')}} : </label>
                        <input type="date" name="input_end_date" id="input_end_date" value="{{ date('Y-m-d') }}" class="form-control" max="{{ date('Y-m-d') }}">
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr>
                                <th>{{__('label.#')}}</th>
                                <th>{{__('label.users')}}</th>
                                <th>{{__('label.basic_info')}}</th>
                                <th>{{__('label.result')}}</th>
                                <th>{{__('label.percentage')}}</th>
                                <th>{{__('label.winning_coin')}}</th>
                                <th>{{__('label.status')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <script>
        $("#input_user").select2();

        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax:
                    {
                    url: "{{ route('admin.videoleaderboard.index') }}",
                    data: function(d){
                        d.input_category = $('#input_category').val();
                        d.input_skill = $('#input_skill').val();
                        d.input_classification = $('#input_classification').val();
                        d.input_level = $('#input_level').val();
                        d.input_user = $('#input_user').val();
                        d.input_start_date = $('#input_start_date').val();
                        d.input_end_date = $('#input_end_date').val();
                    },
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return data ? `<div style="text-align: left;">${data.user_name || '-'}<br><span style="font-size: 14px; font-weight: 600;">${data.full_name || '-'}</span></div>` : '-';
                        }
                    },
                    {
                        data: 'basic_info',
                        name: 'basic_info',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `<div style="text-align: left; font-size: 14px;">
                                        <strong>{{__('label.category')}} : </strong> ${row.category?.name || '-'}<br>
                                        <strong>{{__('label.skill')}} : </strong> ${row.skill?.name || '-'}<br>
                                        <strong>{{__('label.classification')}} : </strong> ${row.classification?.name || '-'}<br>
                                        <strong>{{__('label.level')}} : </strong> ${row.level?.name || '-'}<br>
                                    </div>`;  
                        }
                    },
                    {
                        data: 'result',
                        name: 'result',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row) {
                            return `
                                <div style="text-align: left;">
                                    <div><strong>{{__('label.total_questions')}} : </strong>${row.total_questions ?? 0}</div>
                                    <div><strong>{{__('label.attended')}} : </strong>${row.questions_attended ?? 0}</div>
                                    <div><strong>{{__('label.correct')}} : </strong>${row.correct_answers ?? 0}</div>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'percentage',
                        name: 'percentage',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}%</span>`;
                        }
                    },
                    {
                        data: 'winning_coin',
                        name: 'winning_coin',
                        render: function(data) {
                            return `<span style="font-size: 20px; font-weight: 600;" class="primary-color">${data ?? 0}<i class="fa-solid fa-sack-dollar ml-3 fa-lg"></i></span>`;
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                    },
                ]
            });

            $('#input_category, #input_skill, #input_classification, #input_level, #input_user, #input_start_date, #input_end_date').change(function(){
                table.draw();
            });
        });
    </script>
@endsection